

// core/controllers/UserController.ts
import { Request, Response } from 'express';
import { IUser } from '../models/User';
import { UserService } from '../services/UserService';

export class UserController {
   
    // Get all users : step 2
    static async getAll(req: Request, res: Response) {
        try {
            const users = await UserService.getAllUsers();
            res.render('users/index', { users });
        } catch (error) {
            res.status(500).render('error', { error: 'Failed to fetch users' });
        }
    }



    // Show single user
    static async show(req: Request, res: Response) {
        try {
            const id = parseInt(req.params.id);
            const user = await UserService.getUserById(id);
            if (user) {
                res.render('users/show', { user });
            } else {
                res.status(404).render('error', { error: 'User not found' });
            }
        } catch (error) {
            res.status(500).render('error', { error: (error as Error).message || 'Failed to fetch user' });
        }
    }


    // Show create form
    static createForm(req: Request, res: Response) {
        res.render('users/create');
    }

    

    // Create user :  //3rd start from here

    static async create(req: Request, res: Response) {
        try {
            const user: IUser = {
                name: req.body.name,
                email: req.body.email,
                age: req.body.age,
                class: req.body.class,
                section: req.body.section
            };
            await UserService.createUser(user);
            res.redirect('/users');
        } catch (error) {
            res.status(400).render('users/create', {
                error: (error as Error).message || 'Failed to create user',
                form: req.body
            });
        }
    }


    // Show edit form : previous
  
    static async editForm(req: Request, res: Response) {
        try {
            const id = parseInt(req.params.id);
            const user = await UserService.getUserById(id);
            if (user) {
                res.render('users/edit', { user });
            } else {
                res.status(404).render('error', { error: 'User not found' });
            }
        } catch (error) {
            res.status(500).render('error', { error: 'Failed to fetch user' });
        }
    }



    // Update user : previous
    static async update(req: Request, res: Response) {
        try {
            const id = parseInt(req.params.id);
            const user: IUser = {
                name: req.body.name,
                email: req.body.email,
                age: req.body.age,
                class: req.body.class,
                section: req.body.section
            };
            const success = await UserService.updateUser(id, user);
            if (success) {
                res.redirect('/users');
            } else {
                res.status(404).render('error', { error: 'User not found' });
            }
        } catch (error) {
            res.status(500).render('error', { error: 'Failed to update user' });
        }
    }


    // Delete user 
    static async delete(req: Request, res: Response) {
        try {
            const id = parseInt(req.params.id);
            await UserService.deleteUser(id);
            res.redirect('/users');
        } catch (error) {
            res.status(500).render('error', { error: 'Failed to delete user' });
        }
    }


}